setwd("<your directory or folder path>")

#df1 <- read.csv("20191121 Example 17.1 Time-to-Event Censored Data.csv")
df1 <- read.csv("20191121 Example 17.1 Time-to-Event Censored Data.csv")
#
#
#  Need library(survival) for this code to work
#  only needs to run once in a session
library(survival) 
#

# VARIABLES:
# 
# Time
# Censor
#
attach(df1)

surv.obj <- Surv(time=Time,event=Censor)


surv.model <- survfit(formula = surv.obj ~ 1,data=df1)

summary(surv.model)
#
#   Selected attributes of object surv.model:
#   surv.model$n:  total sample size
#   surv.model$time: vector of survival times
#   surv.model$surv:  vector of survival probability estimates
#   surv.model$type: type of censoring
#   surv.model$std.err: vector of survival probability estimate standard errors
#   surv.model$upper: vector of survival probability estimate upper confidence limits
#   surv.model$lower: vector of survival probability estimate lower confidence limits
#   surv.model$conf.type: transformation used to compute confidence limits
#   surv.model$conf.int: confidence level
#
#
# Now fit a predictive model for survival time
#
s.time <- surv.model$time
s.time.sq <- s.time**2
Ht <- -log(surv.model$surv)
Ht.model <- lm(Ht ~ s.time + s.time.sq)
#
#  Check quality of model fit:
#
summary(Ht.model)
B0 <- Ht.model$coefficients[1]
B1 <- Ht.model$coefficients[2]
B2 <- Ht.model$coefficients[3]
#
#  Compute the predicted survival probabilities
#
pred.surv <- exp(-(B0 + B1*s.time + B2*s.time.sq))

plot(x=surv.model$time,y=surv.model$surv,main="Time to Event",xlab="Survival Time",ylim=c(0.0,1.0),ylab="Probability",pch=3,col="black",type="p")
points(x=surv.model$time,y=pred.surv,pch=1,col="blue",type="p")
legend(x=100.0,y=0.90,legend=c("Kaplan-Meier Survival","Model Predictions"),col=c("black","blue"),pch=c(3,1))
